/* grecs - Gray's Extensible Configuration System
   Copyright (C) 2007-2025 Sergey Poznyakoff

   Grecs is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 3 of the License, or (at your
   option) any later version.

   Grecs is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Grecs. If not, see <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <grecs.h>
#include <wordsplit.h>

struct grecs_txtacc *
grecs_line_acc_create(void)
{
	return grecs_txtacc_create();
}

void
grecs_line_acc_free(struct grecs_txtacc *acc)
{
	grecs_txtacc_free(acc);
}

void
grecs_line_acc_grow_char(struct grecs_txtacc *acc, int c)
{
	char t = c;
	grecs_txtacc_grow(acc, &t, 1);
}

int
grecs_line_acc_grow_char_unescape(struct grecs_txtacc *acc, int c)
{
	if (c != '\n') {
		int uc = wordsplit_c_unquote_char(c);
		grecs_line_acc_grow_char(acc, uc ? uc : c);
		return !uc;
	}
	return 0;
}

void
grecs_line_acc_grow(struct grecs_txtacc *acc, const char *text, size_t len)
{
	grecs_txtacc_grow(acc, text, len);
}

/* Same, but unescapes the last character from text */
void
grecs_line_acc_grow_unescape_last(struct grecs_txtacc *acc,
				  char *text, size_t len,
				  grecs_locus_t const *loc)
{
	grecs_txtacc_grow(acc, text, len - 2);
	if (grecs_line_acc_grow_char_unescape(acc, text[len - 1]) && loc)
		grecs_warning(loc, 0,
			      _("unknown escape sequence: '\\%c'"),
			      text[len - 1]);
}

void
grecs_line_begin(struct grecs_txtacc **acc)
{
	if (!*acc)
		*acc = grecs_line_acc_create();
}

char *
grecs_line_finish(struct grecs_txtacc *acc)
{
	grecs_line_acc_grow_char(acc, 0);
	return grecs_txtacc_finish(acc, 1);
}




